<?php
/**
 * Plugin Name: Hi-Slider for Elementor
 * Description: A custom Elementor widget slider using Bootstrap Carousel.
 * Version: 1.0
 * Author: Hi Classic
* Author URI:  https://hiclassic.site/
* Text Domain: hi-slider
 * License: GPLv2 or later
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) exit; // Prevent direct access

// Ensure Elementor is installed
function hi_slider_check_elementor() {
    if (!did_action('elementor/loaded')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die('This plugin requires Elementor to be installed and activated.');
    }
}
add_action('plugins_loaded', 'hi_slider_check_elementor');

// Register Widget
function register_hi_slider_widget($widgets_manager) {
    require_once(plugin_dir_path(__FILE__) . 'hi-slider-widget.php');
    $widgets_manager->register(new \Hi_Slider_Widget());
}
add_action('elementor/widgets/register', 'register_hi_slider_widget');

// Enqueue Bootstrap if not already loaded
function enqueue_hi_slider_scripts() {
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_style('hi-slider-css', plugin_dir_url(__FILE__) . 'hi-slider.css');
}
add_action('wp_enqueue_scripts', 'enqueue_hi_slider_scripts');
add_action('elementor/frontend/after_enqueue_scripts', 'enqueue_hi_slider_scripts');
