<?php
/**
 * The template for displaying singular post-types: posts and user-defined custom post types.
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// This will display the custom header template or fallback to the default WordPress header
get_header();

while ( have_posts() ) {
    the_post(); ?>
    
    <div <?php post_class('hi-primary'); ?>> <!-- Added post_class() -->
        <div class="hi-content">
            <?php
            // Check if the post has a featured image
            if ( has_post_thumbnail() ) {
                // Display the featured image as a banner
                the_post_thumbnail( 'full', array( 'class' => 'post-banner' ) ); 
            }
            ?>
            <h1><?php the_title(); ?></h1>
            <?php 
                the_content(); 

                //Display post tags
                the_tags( '<p class="post-tags"><strong>Tags:</strong> ', ', ', '</p>' );

                // Add pagination for multi-page posts
                wp_link_pages( array(
                    'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'hi-classic' ) . '</span>',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) ); 
            ?>
        </div>
    </div>

<?php } ?>

<?php
//Load comments template if comments are enabled
if ( comments_open() || get_comments_number() ) {
    comments_template();
}
?>

<?php
// This will display the custom footer template or fallback to the default WordPress footer
get_footer();
?>
