<?php
/**
 * The template for displaying search results.
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); // Include the header.php file

if ( have_posts() ) : // If there are search results
    echo '<h1>' . sprintf( esc_html__( 'Search Results for: %s', 'hi-classic' ), get_search_query() ) . '</h1>';
    while ( have_posts() ) : the_post(); // Loop through the results
        ?>
        <div class="search-result">
            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <p><?php the_excerpt(); ?></p>
        </div>
        <?php
    endwhile;
else : // If no results are found
    echo '<p>' . esc_html__( 'Sorry, no results found for your search.', 'hi-classic' ) . '</p>';
endif;

get_footer(); // Include the footer.php file