<?php
/**
 * The template for displaying  custom pages.
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
?>
<?php
get_header();
?>
<?php
    while ( have_posts() ) {
        the_post(); ?>
        
        <div <?php post_class('hi-primary'); ?>> <!-- Added post_class() -->
            <div class="hi-content">
                <h1><?php the_title(); ?></h1>
                <?php 
                    the_content(); 

                    // Add pagination for multi-page pages
                    wp_link_pages( array(
                        'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'hi-classic' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) ); 
                ?>
            </div>
        </div>

    <?php } 
?>
<?php
// Load comments template if comments are enabled
if ( comments_open() || get_comments_number() ) {
    comments_template();
}
?>
<?php
// This will display the custom footer template or fallback to the default WordPress footer
get_footer();
?>