<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

function hi_styles() {
    // Enqueue the main style.css (this is the default WordPress style for your theme)
    wp_enqueue_style('theme-style', get_stylesheet_uri());

    // Enqueue the custom style.css from the assets/css folder
    wp_enqueue_style(
        'custom-style', // Handle for the custom stylesheet
        get_template_directory_uri() . '/assets/css/theme-style.css', 
        array('theme-style'), 
        filemtime(get_template_directory() . '/assets/css/theme-style.css'), // Versioning to avoid cache issues
        'all' // Media type
    );
}
add_action('wp_enqueue_scripts', 'hi_styles');

function hi_scripts() {
    // Ensure the script is enqueued with correct versioning
    wp_enqueue_script(
        'hi_script',
        get_template_directory_uri() . '/assets/js/main.js',
        array(),
        filemtime(get_template_directory() . '/assets/js/main.js'),
        true
    );
}
add_action('wp_enqueue_scripts', 'hi_scripts'); 

// theme settings file
require get_template_directory() . '/inc/theme-setting.php';
require get_template_directory() . '/inc/required-plugin.php';
require get_template_directory() . '/inc/hi-custom-css.php';

// Register Menus and Logo Support in functions.php
function hitheme_register_menus_and_logo() {
    // Register Navigation Menus
    register_nav_menus(
        array(
            'primary-menu' => __( 'Primary Menu', 'hi-classic' ),
            'footer-menu'  => __( 'Footer Menu', 'hi-classic' ),
        )
    );

    // Enable support for custom logo
    add_theme_support( 'custom-logo' );
}
add_action( 'after_setup_theme', 'hitheme_register_menus_and_logo' );
