<?php
/**
 * Plugin Required: Elementor
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
// Hook to add admin notice for required plugin
add_action('admin_notices', 'hi_theme_required_plugin_notice');

function hi_theme_required_plugin_notice() {
    // Check if Elementor is installed and activated
    if ( ! is_plugin_active( 'elementor/elementor.php' ) ) {
        // Display admin notice if Elementor is not active
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php _e( 'Hi Classic Theme requires the Elementor plugin to be installed and activated. Please install Elementor.', 'hi-classic' ); ?></p>
            <p><a href="<?php echo esc_url( admin_url( 'plugin-install.php?s=elementor&tab=search&type=term' ) ); ?>" class="button-primary"><?php _e( 'Install Elementor', 'hi-classic' ); ?></a></p>
        </div>
        <?php
    }
}
?>