<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// Add a Custom Meta Box to Elementor Page Settings
function add_custom_css_metabox() {
    add_meta_box(
        'custom_css_metabox',            // Metabox ID
        'Hi Classic Custom CSS ',      // Title of the metabox
        'render_custom_css_metabox',     // Callback to render the metabox content
        'page',                          // Post type (in this case, it's pages)
        'normal',                        // Context (normal is typical for most metaboxes)
        'high'                           // Priority
    );
}
add_action('add_meta_boxes', 'add_custom_css_metabox');

// Render the custom CSS input field
function render_custom_css_metabox($post) {
    // Retrieve any existing custom CSS from the post meta
    $custom_css = get_post_meta($post->ID, '_custom_css', true);

    // Display the textarea for CSS input
    echo '<textarea name="custom_css" style="width:100%; height: 200px;">' . esc_textarea($custom_css) . '</textarea>';
    echo '<p><em>Enter your custom CSS code here. It will apply to this specific page. DO NOT INCLUDE the open and close style tag on your code </em></p>';
}

// Save the Custom CSS
function save_custom_css($post_id) {
    // Check for autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return $post_id;

    // Only save if custom CSS is set
    if (isset($_POST['custom_css'])) {
        $custom_css = sanitize_textarea_field($_POST['custom_css']);
        update_post_meta($post_id, '_custom_css', $custom_css);
    }

    return $post_id;
}
add_action('save_post', 'save_custom_css');

// Output the Custom CSS on the Frontend
function output_custom_css() {
    if (is_page()) {
        global $post;

        // Retrieve the custom CSS from the page meta
        $custom_css = get_post_meta($post->ID, '_custom_css', true);

        // If there is custom CSS, output it inside a <style> tag
        if (!empty($custom_css)) {
            echo '<style type="text/css">' . esc_html($custom_css) . '</style>';
        }
    }
}
add_action('wp_head', 'output_custom_css');