<?php
/**
 * Theme functions
 *
 * @package Hi Classic
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Theme Support Features
 */
function hi_theme_support() {

    // Enable RSS feed links in the head (SEO-friendly)
    add_theme_support( 'automatic-feed-links' );

    // Enable dynamic title tags (remove hardcoded <title>)
    add_theme_support( 'title-tag' );

    // Enable featured images
    add_theme_support( 'post-thumbnails' );

    // Enable block editor styles
    add_theme_support( 'wp-block-styles' );

    // Enable responsive embeds (YouTube, Vimeo, etc.)
    add_theme_support( 'responsive-embeds' );

    // Enable HTML5 markup support
    add_theme_support( 'html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'script',
        'style',
    ) );

    // Support wide and full-width block alignment
    add_theme_support( 'align-wide' );

    // Enable custom background support
    add_theme_support( 'custom-background', array(
        'default-color' => 'ffffff',
        'default-image' => '',
        'wp-head-callback' => '_custom_background_cb',
    ) );

    // Enable custom header support
    add_theme_support( 'custom-header', array(
        'default-image' => '',
        'width'         => 1200,
        'height'        => 600,
        'flex-width'    => true,
        'flex-height'   => true,
        'header-text'   => false,
    ) );
}
add_action( 'after_setup_theme', 'hi_theme_support' );

/**
 * Add Editor Styles
 */
function hi_add_editor_styles() {
    add_editor_style( 'assets/css/editor-style.css' ); // Ensure file exists
}
add_action( 'admin_init', 'hi_add_editor_styles' );

/**
 * Enqueue Comment Reply Script
 */
function hi_enqueue_comment_reply_script() {
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'hi_enqueue_comment_reply_script' );

/**
 * Register Custom Block Styles
 */
function hi_register_block_styles() {
    register_block_style(
        'core/image',
        array(
            'name'         => 'rounded-corners',
            'label'        => __( 'Rounded Corners', 'hi-classic' ),
            'inline_style' => '.wp-block-image img { border-radius: 10px; }',
        )
    );
}
add_action( 'init', 'hi_register_block_styles' );

/**
 * Register Custom Block Patterns
 */
function hi_register_block_patterns() {
    register_block_pattern(
        'hi-classic/hero-section',
        array(
            'title'       => __( 'Hero Section', 'hi-classic' ),
            'description' => __( 'A simple hero section with a heading and a button.', 'hi-classic' ),
            'content'     => '<!-- wp:cover {"url":"your-image.jpg","dimRatio":50} -->
                                <div class="wp-block-cover">
                                    <h2>Welcome to Hi Classic</h2>
                                    <a class="wp-block-button__link">Learn More</a>
                                </div>
                              <!-- /wp:cover -->',
        )
    );
}
add_action( 'init', 'hi_register_block_patterns' );

/**
 * Load Main Theme Functions
 */
require get_template_directory() . '/inc/theme-function.php';

/**
 * Register Sidebars
 */
function hi_register_sidebars() {
    register_sidebar( array(
        'name'          => __( 'Primary Sidebar', 'hi-classic' ),
        'id'            => 'primary-sidebar',
        'description'   => __( 'The primary sidebar appears on the right side of your posts and pages.', 'hi-classic' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'hi_register_sidebars' );
