<?php
/**
 * The template for displaying comments.
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<?php
// Check if the post is password protected and if the user has not yet entered the password
if ( post_password_required() ) {
    echo '<p class="no-comments">This post is password protected. Enter the password to view comments.</p>';
    return;
}
?>

<div class="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>
        <h2 class="comments-title">
            <?php
                $comment_count = get_comments_number();
                if ( '1' === $comment_count ) {
                    printf( esc_html__( 'One Comment on &ldquo;%1$s&rdquo;', 'hi-classic' ), get_the_title() );
                } else {
                    printf( esc_html__( '%1$s Comments on &ldquo;%2$s&rdquo;', 'hi-classic' ), $comment_count, get_the_title() );
                }
            ?>
        </h2>

        <ol class="comment-list">
            <?php
            // List comments
            wp_list_comments( array(
                'style'       => 'ol',
                'short_ping'  => true,
                'avatar_size' => 50, // Optional: adjust avatar size
            ) );
            ?>
        </ol><!-- .comment-list -->

        <?php the_comments_pagination( array(
            'prev_text' => __( 'Previous Comments', 'hi-classic' ),
            'next_text' => __( 'Next Comments', 'hi-classic' ),
        ) ); ?>

    <?php else : ?>
        <?php if ( comments_open() ) : ?>
            <!-- If comments are open, display a message that no comments are available -->
            <p class="no-comments"><?php esc_html_e( 'Be the first to comment!', 'hi-classic' ); ?></p>
        <?php else : ?>
            <!-- If comments are closed, display a message -->
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'hi-classic' ); ?></p>
        <?php endif; ?>
    <?php endif; ?>

    <?php
    // Comment form
    comment_form( array(
        'title_reply' => __( 'Leave a Comment', 'hi-classic' ),
        'label_submit' => __( 'Submit Comment', 'hi-classic' ),
    ) );
    ?>

</div><!-- .comments-area -->
