<?php
/**
 * The template for displaying  Specific for Categories Archives
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
} 
 ?>

<?php get_header(); ?>

<main id="hi-primary">
<div class="hi-content">
    <section class="category-archive">
        <?php
        $category = get_queried_object(); // Get category details
        ?>
        <h1>Category: <?php echo esc_html(single_cat_title('', false)); ?></h1>

        <?php if (category_description()) : ?>
            <p><?php echo category_description(); ?></p>
        <?php endif; ?>

        <?php if (have_posts()) : ?>
            <ul>
                <?php while (have_posts()) : the_post(); ?>
                    <li>
                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <p><?php the_excerpt(); ?></p>
                    </li>
                <?php endwhile; ?>
            </ul>
            <?php the_posts_pagination(); ?>
        <?php else : ?>
            <p>No posts found in this category.</p>
        <?php endif; ?>
    </section>
        </div>
</main>
<?php get_footer(); ?>
