<?php
/**
 * The template for displaying  Specific for Author Archives
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
} 
 ?>
<?php get_header(); ?>

<main id="hi-primary">
        <div class="hi-content">
    <section class="author-archive">
        <?php
        $author = get_queried_object(); // Get author details
        ?>
        <h1>Posts by <?php echo esc_html($author->display_name); ?></h1>

        <?php if (get_the_author_meta('description')) : ?>
            <p><?php echo esc_html(get_the_author_meta('description')); ?></p>
        <?php endif; ?>

        <?php if (have_posts()) : ?>
            <ul>
                <?php while (have_posts()) : the_post(); ?>
                    <li>
                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <p><?php the_excerpt(); ?></p>
                    </li>
                <?php endwhile; ?>
            </ul>
            <?php the_posts_pagination(); ?>
        <?php else : ?>
            <p>No posts found.</p>
        <?php endif; ?>
    </section>
        </div>
</main>
<?php get_footer(); ?>
