<?php
/**
 * The template for displaying Category Archives, Tag Archives, Date-based Archives, Author Archives, Custom Post Type Archives.
 *
 * @package Hi Classic
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
} 
 ?>
 <?php
get_header(); // Include the header.php file
if ( have_posts() ) : // Check if there are posts to display
    if ( is_category() ) {
        echo '<h1>' . single_cat_title( '', false ) . ' Archive</h1>';
    } elseif ( is_tag() ) {
        echo '<h1>' . single_tag_title( '', false ) . ' Archive</h1>';
    } elseif ( is_author() ) {
        echo '<h1>' . get_the_author() . ' Archive</h1>';
    } elseif ( is_date() ) {
        echo '<h1>' . get_the_date( 'F Y' ) . ' Archive</h1>';
    } else {
        echo '<h1>Archives</h1>';
    }

    // Loop through and display posts
    while ( have_posts() ) : the_post();
        ?>
        <div class="hi-primary">
        <div class="hi-content">
        <div class="archive-post">
            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            <p><?php the_excerpt(); ?></p>
        </div>
        </div>
        </div>
        <?php
    endwhile;

    // Pagination
    the_posts_pagination();

else :
    echo '<p>No posts found</p>';
endif;

get_footer(); // Include the footer.php file
