<?php
/**
 * Plugin Name: Hi-Classic-Popup
 * Description: Lightweight Elementor extension that lets you create popups using your saved templates.
 * Version:     1.0.3
 * Author:      Hi Classic
 * Text Domain: hi-classic-popup
 * Author URI:  https://hiclassic.site/
 * License:     GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * -------------------------------------------------
 * 1️⃣ Register custom Elementor document type (Hi Classic Popup Button)
 * -------------------------------------------------
 */
function hi_classic_register_popup_document() {
	if ( ! did_action( 'elementor/loaded' ) ) {
		return;
	}

	require_once __DIR__ . '/includes/class-hi-classic-popup-document.php';

	add_action( 'elementor/documents/register', function( $documents_manager ) {
		$documents_manager->register_document_type(
			'hi-classic-popup',
			'Hi_Classic_Popup_Document'
		);
	}, 11 );
}
add_action( 'elementor/init', 'hi_classic_register_popup_document' );

/**
 * -------------------------------------------------
 * 2️⃣ Add custom category in Elementor
 * -------------------------------------------------
 */
add_action( 'elementor/init', function() {
	\Elementor\Plugin::$instance->elements_manager->add_category(
		'hi-classic-popup',
		[
			'title' => __( 'Hi Classic Popup', 'hi-classic-popup' ),
			'icon'  => 'fa fa-bullhorn',
		]
	);
});

/**
 * -------------------------------------------------
 * 3️⃣ Register the Elementor Widget
 * -------------------------------------------------
 */
function hi_classic_popup_register_widgets( $widgets_manager ) {
	require_once __DIR__ . '/includes/widgets/widget-popup-button.php';
	$widgets_manager->register( new \Hi_Classic_Popup_Button() );
}
add_action( 'elementor/widgets/register', 'hi_classic_popup_register_widgets' );

/**
 * -------------------------------------------------
 * 4️⃣ Enqueue frontend assets
 * -------------------------------------------------
 */
function hi_classic_popup_scripts() {
	$css_path = plugin_dir_path(__FILE__) . 'assets/css/style.css';
	$js_path  = plugin_dir_path(__FILE__) . 'assets/js/script.js';

	wp_enqueue_style(
		'hi-classic-popup-style',
		plugin_dir_url(__FILE__) . 'assets/css/style.css',
		[],
		file_exists( $css_path ) ? filemtime( $css_path ) : '1.0.0'
	);

	wp_enqueue_script(
		'hi-classic-popup-script',
		plugin_dir_url(__FILE__) . 'assets/js/script.js',
		[ 'jquery' ],
		file_exists( $js_path ) ? filemtime( $js_path ) : '1.0.0',
		true
	);

	wp_localize_script(
		'hi-classic-popup-script',
		'hiClassicPopup',
		[
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( 'hi-classic-popup-nonce' ),
		]
	);
}
add_action( 'wp_enqueue_scripts', 'hi_classic_popup_scripts' );

/**
 * -------------------------------------------------
 * 5️⃣ AJAX loader for popup template
 * -------------------------------------------------
 */
add_action( 'wp_ajax_hi_classic_popup_get_template', 'hi_classic_popup_get_template' );
add_action( 'wp_ajax_nopriv_hi_classic_popup_get_template', 'hi_classic_popup_get_template' );

function hi_classic_popup_get_template() {
	check_ajax_referer( 'hi-classic-popup-nonce', 'nonce' );
	$template_id = isset($_POST['template_id']) ? intval($_POST['template_id']) : 0;

	if ( ! $template_id ) {
		wp_send_json_error( 'Missing template ID' );
	}

	$content = \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $template_id );
	wp_send_json_success( $content );
}
