jQuery(document).ready(function($) {

    // Open popup on button click
    $('body').on('click', '.hi-popup-btn', function(e) {
        e.preventDefault();

        let templateId = $(this).data('template-id');
        if (!templateId) return;

        $.ajax({
            url: hiClassicPopup.ajaxurl,
            type: 'POST',
            data: {
                action: 'hi_classic_popup_get_template',
                template_id: templateId,
                nonce: hiClassicPopup.nonce
            },
            success: function(response) {
                if (response.success === false) {
                    console.error(response.data);
                    return;
                }

                $('body').append(
                    '<div class="hi-popup-overlay">' +
                        '<div class="hi-popup-content">' +
                            '<span class="hi-popup-close">&times;</span>' +
                            response.data +
                        '</div>' +
                    '</div>'
                );
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });
    });

    // Close popup when clicking overlay or close button
    $('body').on('click', '.hi-popup-overlay', function(e) {
        if ($(e.target).is('.hi-popup-overlay') || $(e.target).is('.hi-popup-close')) {
            $('.hi-popup-overlay').remove();
        }
    });

});
