<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Hi_Classic_Form_Widget extends \Elementor\Widget_Base {

    public function get_name() { return 'hi-classic-form'; }
    public function get_title() { return __( 'Hi Classic Form', 'hi-classic-form' ); }
    public function get_icon() { return 'eicon-form-horizontal'; }
    public function get_categories() { return array( 'general' ); }

    public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );
        add_action( 'admin_footer', array( $this, 'print_editor_inline_script' ) );
    }

    public function print_editor_inline_script() {
        if ( ! ( defined( 'ELEMENTOR_VERSION' ) && class_exists( '\Elementor\Plugin' ) ) ) return;
        try {
            $editor = \Elementor\Plugin::instance()->editor;
            if ( ! ( is_object( $editor ) && method_exists( $editor, 'is_edit_mode' ) && $editor->is_edit_mode() ) ) return;
        } catch ( \Exception $e ) { return; }
        ?>
        <script>
        (function($, elementor){
            elementor.hooks.addAction('panel/open_editor/widget', function(panel, model, view){
                try{
                    if(!model || model.get('widgetType')!=='hi-classic-form') return;
                    var panelEl = panel.$el;

                    // autogen keys from label in repeater
                    panelEl.on('input.hiClassicForm','input[data-setting="field_label"]', function(){
                        var $label = $(this);
                        var row = $label.closest('.elementor-repeater-row, .elementor-repeater-row-controls, .elementor-control-repeater, .elementor-control');
                        if(row.length===0) row = $label.closest('.elementor-control');
                        var labelVal = $label.val()||'';
                        var slug = labelVal.toString().toLowerCase().replace(/[^a-z0-9]+/g,'_').replace(/^_+|_+$/g,'');
                        var $key = row.find('input[data-setting="field_key"]').first();
                        if((!$key || $key.length===0)) $key = $label.closest('.elementor-control').siblings().find('input[data-setting="field_key"]').first();
                        if($key && $key.length) $key.val(slug).trigger('input').trigger('change');
                    });

                    panelEl.on('click.hiClassicForm','.elementor-repeater-add', function(){
                        setTimeout(function(){ panelEl.find('input[data-setting="field_label"]').last().trigger('input'); },150);
                    });

                    // live preview update when columns changes
                    panelEl.on('change input', 'select[data-setting="columns"], input[data-setting="columns"]', function(){
                        setTimeout(function(){
                            panel.$el.find('.hi-classic-form-grid-preview').each(function(){
                                var $p = $(this); var cols = panel.model.get('columns') || 1; $p.empty();
                                for(var i=1;i<=cols;i++){ $p.append('<div class="hi-preview-col">Column '+i+'</div>'); }
                            });
                        },50);
                    });

                } catch(e){}
            });
        })(jQuery, window.elementor);
        </script>
        <?php
    }

    protected function register_controls() {
        $repeater = new \Elementor\Repeater();
        $repeater->add_control('field_label', ['label'=>__('Label','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>'Field']);
        $repeater->add_control('field_key', ['label'=>__('Key (name)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::HIDDEN,'default'=>'']);
        $repeater->add_control('field_type', ['label'=>__('Type','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SELECT,'options'=>['text'=>'Text','email'=>'Email','textarea'=>'Textarea'],'default'=>'text']);
        $repeater->add_control('field_placeholder', ['label'=>__('Placeholder','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>'']);
        $repeater->add_control('field_required', ['label'=>__('Required','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SWITCHER,'label_on'=>'Yes','label_off'=>'No','return_value'=>'yes','default'=>'']);
        $repeater->add_control('field_column', ['label'=>__('Column span (1-5)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SELECT,'options'=>['1'=>'1','2'=>'2','3'=>'3','4'=>'4','5'=>'5'],'default'=>'1']);

        $this->start_controls_section('section_fields',['label'=>__('Form Fields','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_CONTENT]);
        $this->add_control('fields',['label'=>__('Fields','hi-classic-form'),'type'=>\Elementor\Controls_Manager::REPEATER,'fields'=>$repeater->get_controls(),'default'=>[['field_label'=>'Name','field_key'=>'name','field_type'=>'text','field_required'=>'yes','field_column'=>'2'],['field_label'=>'Email','field_key'=>'email','field_type'=>'email','field_required'=>'yes','field_column'=>'3'],['field_label'=>'Message','field_key'=>'message','field_type'=>'textarea','field_required'=>'yes','field_column'=>'5']],'title_field'=>'{{{ field_label }}}']);
        $this->add_control('show_labels',['label'=>__('Show Labels','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SWITCHER,'label_on'=>'Show','label_off'=>'Hide','return_value'=>'yes','default'=>'yes']);
        $this->add_control('show_asterisk',['label'=>__('Show Required Asterisk (*)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SWITCHER,'label_on'=>'Yes','label_off'=>'No','return_value'=>'yes','default'=>'yes']);
        $this->end_controls_section();

        $this->start_controls_section('section_settings',['label'=>__('Settings','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_CONTENT]);
        $this->add_control('to',['label'=>__('Recipient Email','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>get_option('admin_email')]);
        $this->add_control('subject',['label'=>__('Email Subject','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>__('New message from Hi Classic Form','hi-classic-form')]);
        $this->add_control('submit_text',['label'=>__('Button Text','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>__('Send Message','hi-classic-form')]);
        $this->add_control('success_message',['label'=>__('Success Message','hi-classic-form'),'type'=>\Elementor\Controls_Manager::TEXT,'default'=>__('Thanks for your message. We will get back to you soon.','hi-classic-form')]);
        $this->add_control('columns',['label'=>__('Columns per row','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SELECT,'options'=>['1'=>'1','2'=>'2','3'=>'3','4'=>'4','5'=>'5'],'default'=>'2']);
        $this->end_controls_section();

        // Style controls (layout + input + button + typography)
        $this->start_controls_section('style_layout',['label'=>__('Layout','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_STYLE]);
        $this->add_control('column_gap',['label'=>__('Column Gap (px)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SLIDER,'range'=>['px'=>['min'=>0,'max'=>60]],'default'=>['size'=>16],'selectors'=>['{{WRAPPER}} .hi-form-grid'=>'gap: {{SIZE}}{{UNIT}};']]);
        $this->add_control('row_gap',['label'=>__('Row Gap (px)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SLIDER,'range'=>['px'=>['min'=>0,'max'=>60]],'default'=>['size'=>16],'selectors'=>['{{WRAPPER}} .hi-form-grid'=>'row-gap: {{SIZE}}{{UNIT}};']]);
        $this->end_controls_section();

        $this->start_controls_section('style_input',['label'=>__('Input','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_STYLE]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name'=>'input_typo','label'=>__('Input Typography','hi-classic-form'),'selector'=>'{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea']);
        $this->add_control('input_bg',['label'=>__('Background','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#ffffff','selectors'=>['{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea'=>'background: {{VALUE}};']]);
        $this->add_control('input_border_color',['label'=>__('Border Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#dddddd','selectors'=>['{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea'=>'border-color: {{VALUE}};']]);
        $this->add_control('input_text_color',['label'=>__('Text Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#222222','selectors'=>['{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea'=>'color: {{VALUE}};']]);
        $this->add_control('input_placeholder_color',['label'=>__('Placeholder Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#999999','selectors'=>['{{WRAPPER}} ::-webkit-input-placeholder'=>'color: {{VALUE}};','{{WRAPPER}} ::-moz-placeholder'=>'color: {{VALUE}};','{{WRAPPER}} ::-ms-input-placeholder'=>'color: {{VALUE}};']]);
        $this->add_control('input_radius',['label'=>__('Border Radius (px)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SLIDER,'range'=>['px'=>['min'=>0,'max'=>50]],'default'=>['size'=>8],'selectors'=>['{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea'=>'border-radius: {{SIZE}}{{UNIT}};']]);
        $this->add_control('input_padding',['label'=>__('Padding (px)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::DIMENSIONS,'size_units'=>['px'],'default'=>['top'=>12,'right'=>12,'bottom'=>12,'left'=>12],'selectors'=>['{{WRAPPER}} .hi-field input, {{WRAPPER}} .hi-field textarea'=>'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};']]);
        $this->end_controls_section();

        $this->start_controls_section('style_button',['label'=>__('Button','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_STYLE]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name'=>'button_typo','label'=>__('Button Typography','hi-classic-form'),'selector'=>'{{WRAPPER}} .hi-classic-button']);
        $this->add_control('button_bg',['label'=>__('Background','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#002b5c','selectors'=>['{{WRAPPER}} .hi-classic-button'=>'background: {{VALUE}};']]);
        $this->add_control('button_text',['label'=>__('Text Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#ffffff','selectors'=>['{{WRAPPER}} .hi-classic-button'=>'color: {{VALUE}};']]);
        $this->add_control('button_radius',['label'=>__('Border Radius (px)','hi-classic-form'),'type'=>\Elementor\Controls_Manager::SLIDER,'range'=>['px'=>['min'=>0,'max'=>50]],'default'=>['size'=>8],'selectors'=>['{{WRAPPER}} .hi-classic-button'=>'border-radius: {{SIZE}}{{UNIT}};']]);
        $this->add_control('button_hover_bg',['label'=>__('Hover Background','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#ffffff']);
        $this->add_control('button_hover_text',['label'=>__('Hover Text Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#002b5c']);
        $this->end_controls_section();

        $this->start_controls_section('style_label',['label'=>__('Label','hi-classic-form'),'tab'=>\Elementor\Controls_Manager::TAB_STYLE]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name'=>'label_typo','label'=>__('Label Typography','hi-classic-form'),'selector'=>'{{WRAPPER}} .hi-field label']);
        $this->add_control('label_color',['label'=>__('Color','hi-classic-form'),'type'=>\Elementor\Controls_Manager::COLOR,'default'=>'#333','selectors'=>['{{WRAPPER}} .hi-field label'=>'color: {{VALUE}};']]);
        $this->end_controls_section();
    }

 protected function render() {
    $settings = $this->get_settings_for_display();
    $fields   = $settings['fields'] ?? array();
    $columns  = max( 1, intval( $settings['columns'] ?? 1 ) );
    $form_id  = 'hi-classic-form-' . $this->get_id();

    $col_gap       = isset( $settings['column_gap']['size'] ) ? intval( $settings['column_gap']['size'] ) : 16;
    $row_gap       = isset( $settings['row_gap']['size'] ) ? intval( $settings['row_gap']['size'] ) : 16;
    $input_radius  = isset( $settings['input_radius']['size'] ) ? intval( $settings['input_radius']['size'] ) : 8;
    $button_radius = isset( $settings['button_radius']['size'] ) ? intval( $settings['button_radius']['size'] ) : 8;

    $style_vars = sprintf(
        '--hi-columns:%d;--hi-col-gap:%spx;--hi-row-gap:%spx;--hi-input-radius:%spx;--hi-button-radius:%spx;',
        $columns,
        $col_gap,
        $row_gap,
        $input_radius,
        $button_radius
    );

    $show_labels   = ( ! empty( $settings['show_labels'] ) && $settings['show_labels'] === 'yes' ) ? 'show' : 'hide';
    $show_asterisk = ( ! empty( $settings['show_asterisk'] ) && $settings['show_asterisk'] === 'yes' ) ? 'show' : 'hide';

    printf(
        '<div id="%s" class="hi-classic-form-wrapper hi-theme-navy" style="%s">',
        esc_attr( $form_id ),
        esc_attr( $style_vars )
    );

    // ✅ Single form only
    echo '<form class="hi-classic-form" method="post" data-form-id="' . esc_attr( $form_id ) . '">';
    wp_nonce_field( 'hi_classic_form', '_hi_classic_form_nonce', true, true );
    printf( '<input type="hidden" name="to" value="%s">', esc_attr( $settings['to'] ?? get_option( 'admin_email' ) ) );
    printf( '<input type="hidden" name="success_message" value="%s">', esc_attr( $settings['success_message'] ?? 'Thanks for your message. We will get back to you soon.' ) );
    printf( '<input type="hidden" name="subject" value="%s">', esc_attr( $settings['subject'] ?? 'New message from Hi Classic Form' ) );

    echo '<div class="hi-form-grid">';
    foreach ( $fields as $field ) {
        $label       = $field['field_label'] ?? '';
        $key         = ! empty( $field['field_key'] ) ? sanitize_text_field( $field['field_key'] ) : preg_replace( '/[^a-z0-9]+/', '_', strtolower( sanitize_title_with_dashes( $label ) ) );
        $type        = $field['field_type'] ?? 'text';
        $placeholder = $field['field_placeholder'] ?? '';
        $span        = intval( $field['field_column'] ?? 1 );
        $span        = min( max( $span, 1 ), 5 );

        $is_required   = ( ! empty( $field['field_required'] ) && $field['field_required'] === 'yes' );
        $required_attr = $is_required ? 'required' : '';

        echo '<div class="hi-field hi-col-span-' . esc_attr( $span ) . '">';
        $show_label_attr = ( $show_labels === 'show' ) ? '' : 'style="display:none;"';
        $asterisk        = ( $show_asterisk === 'show' && $is_required ) ? ' <span class="hi-required">*</span>' : '';

        // ✅ Fixed label escaping
$show_label_attr = ( $show_labels === 'show' ) ? '' : 'display:none;';

printf(
    '<label %s>%s%s</label>',
    $show_label_attr ? 'style="' . esc_attr( $show_label_attr ) . '"' : '',
    esc_html( $label ),
    wp_kses_post( $asterisk )
);



        if ( $type === 'textarea' ) {
            printf(
                '<textarea name="form[%s]" placeholder="%s" %s></textarea>',
                esc_attr( $key ),
                esc_attr( $placeholder ),
                esc_attr( $required_attr )
            );
        } else {
            printf(
                '<input type="%s" name="form[%s]" placeholder="%s" %s>',
                esc_attr( $type ),
                esc_attr( $key ),
                esc_attr( $placeholder ),
                esc_attr( $required_attr )
            );
        }

        echo '</div>';
    }
    echo '</div>';

    printf( '<div class="hi-submit-wrap"><button class="hi-classic-button" type="submit">%s</button></div>', esc_html( $settings['submit_text'] ?? 'Send Message' ) );
    echo '<div class="hi-form-response" aria-live="polite"></div>';
    echo '</form>';
    echo '</div>'; // close wrapper

    // ✅ Hover works now (button is inside wrapper)
    $btn_hover_bg   = $settings['button_hover_bg'] ?? '#ffffff';
    $btn_hover_text = $settings['button_hover_text'] ?? '#002b5c';
    echo '<style>
        #' . esc_attr( $form_id ) . ' .hi-classic-button:hover {
            background:' . esc_attr( $btn_hover_bg ) . ';
            color:' . esc_attr( $btn_hover_text ) . ';
        }
    </style>';
}



    protected function render_data_attributes($attrs=array()) {
        $out='';
        foreach($attrs as $k=>$v) $out .= sprintf(' %s="%s"', esc_attr($k), esc_attr($v));
        return $out;
    }
}
