(function ($) {
    $(document).on('submit', '.hi-classic-form', function (e) {
        e.preventDefault();

        var $form = $(this);
        var $response = $form.find('.hi-form-response');

        $response.removeClass('hi-success hi-error').text('Sending...');

        // Gather form data
        var data = $form.serializeArray();
        data.push({ name: '_hi_classic_form_nonce', value: HiClassicForm.nonce });

        // Helper to actually send the AJAX request
        var sendAjax = function (extraData) {
            var submitData = $.param(data);
            if (extraData) {
                submitData += '&' + $.param(extraData);
            }

            $.ajax({
                url: HiClassicForm.ajax_url,
                method: 'POST',
                data: submitData + '&action=hi_classic_form_submit',
                dataType: 'json'
            })
                .done(function (res) {
                    if (res && res.success) {
                        $response.addClass('hi-success').text(res.message);
                        $form[0].reset();
                    } else {
                        $response.addClass('hi-error').text(res.message || 'Failed to send.');
                    }
                })
                .fail(function () {
                    $response.addClass('hi-error').text('An error occurred. Please try again.');
                });
        };

        // ✅ If reCAPTCHA v3 site key exists, get token first
        if (typeof HiClassicForm !== 'undefined' && HiClassicForm.recaptcha_site_key) {
            if (typeof grecaptcha !== 'undefined' && typeof grecaptcha.execute === 'function') {
                grecaptcha.ready(function () {
                    grecaptcha
                        .execute(HiClassicForm.recaptcha_site_key, { action: 'submit' })
                        .then(function (token) {
                            if (token) {
                                sendAjax({ 'g-recaptcha-response': token });
                            } else {
                                console.warn('No reCAPTCHA token received. Sending without token.');
                                sendAjax();
                            }
                        })
                        .catch(function (err) {
                            console.warn('reCAPTCHA error:', err);
                            sendAjax();
                        });
                });
            } else {
                console.warn('reCAPTCHA not loaded properly; submitting without token.');
                sendAjax();
            }
        } else {
            // 🚀 No reCAPTCHA configured — proceed normally
            sendAjax();
        }
    });
})(jQuery);
