<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action(
	'admin_menu',
	function() {
		add_options_page(
			'Hi Classic Form Test Email',
			'Hi Classic Form Test Email',
			'manage_options',
			'hi-classic-form-test-email',
			'hi_classic_form_test_email_page'
		);
	}
);

function hi_classic_form_test_email_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	if (
		isset( $_POST['hi_classic_form_test_email_nonce'] ) &&
		wp_verify_nonce(
			sanitize_text_field( wp_unslash( $_POST['hi_classic_form_test_email_nonce'] ) ),
			'hi_classic_form_test_email_action'
		)
	) {
		// ✅ Safely get posted email
		$to = get_option( 'admin_email' );

		if ( isset( $_POST['hi_test_email_to'] ) ) {
    $to = sanitize_email( wp_unslash( $_POST['hi_test_email_to'] ) );
}


		$subject = 'Hi Classic Form Test Email';
		$message = 'This is a test email from Hi Classic Form plugin.';
		$headers = array( 'Content-Type: text/html; charset=UTF-8' );

		$sent = wp_mail( $to, $subject, $message, $headers );

		echo '<div class="notice notice-' . ( $sent ? 'success' : 'error' ) . '"><p>';
		if ( $sent ) {
			echo '✅ ' . esc_html__( 'Test email successfully sent to', 'hi-classic-form' ) . ' ' . esc_html( $to );
		} else {
			echo esc_html__( '❌ Failed to send test email. Please check your SMTP or email settings.', 'hi-classic-form' );
		}
		echo '</p></div>';
	}

	echo '<div class="wrap"><h1>' . esc_html__( 'Hi Classic Form - Test Email', 'hi-classic-form' ) . '</h1>';
	echo '<form method="post">';
	wp_nonce_field( 'hi_classic_form_test_email_action', 'hi_classic_form_test_email_nonce' );
	echo '<table class="form-table"><tr><th scope="row"><label for="hi_test_email_to">' . esc_html__( 'Recipient Email', 'hi-classic-form' ) . '</label></th>';
	echo '<td><input type="email" id="hi_test_email_to" name="hi_test_email_to" value="' . esc_attr( get_option( 'admin_email' ) ) . '" class="regular-text" /></td></tr></table>';
	submit_button( esc_html__( 'Send Test Email', 'hi-classic-form' ) );
	echo '</form></div>';
}
