<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'admin_menu', function() {
    // Add under Settings (to match existing plugin pages)
    add_options_page(
        'Hi Classic Form - reCAPTCHA Settings',
        'Hi Classic Form - reCAPTCHA Settings',
        'manage_options',
        'hi-classic-form-recaptcha-settings',
        'hi_classic_form_recaptcha_settings_page'
    );
} );

add_action( 'admin_init', function() {
    register_setting(
        'hi_classic_form_recaptcha',
        'hi_classic_form_recaptcha_site_key',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    register_setting(
        'hi_classic_form_recaptcha',
        'hi_classic_form_recaptcha_secret_key',
        array(
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
} );

function hi_classic_form_recaptcha_settings_page() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    // ✅ Properly handle and sanitize nonce
    $hi_classic_form_nonce = '';
    if ( isset( $_POST['hi_classic_form_recaptcha_nonce'] ) ) {
        $hi_classic_form_nonce = sanitize_text_field( wp_unslash( $_POST['hi_classic_form_recaptcha_nonce'] ) );
    }

    if ( ! empty( $hi_classic_form_nonce ) && wp_verify_nonce( $hi_classic_form_nonce, 'hi_classic_form_recaptcha_action' ) ) {
        if ( isset( $_POST['hi_classic_form_recaptcha_site_key'] ) ) {
            update_option( 'hi_classic_form_recaptcha_site_key', sanitize_text_field( wp_unslash( $_POST['hi_classic_form_recaptcha_site_key'] ) ) );
        }
        if ( isset( $_POST['hi_classic_form_recaptcha_secret_key'] ) ) {
            update_option( 'hi_classic_form_recaptcha_secret_key', sanitize_text_field( wp_unslash( $_POST['hi_classic_form_recaptcha_secret_key'] ) ) );
        }
        echo '<div class="updated"><p>' . esc_html__( 'Settings saved.', 'hi-classic-form' ) . '</p></div>';
    }

    $site_key   = esc_attr( get_option( 'hi_classic_form_recaptcha_site_key', '' ) );
    $secret_key = esc_attr( get_option( 'hi_classic_form_recaptcha_secret_key', '' ) );

    echo '<div class="wrap"><h1>' . esc_html__( 'Hi Classic Form - reCAPTCHA Settings', 'hi-classic-form' ) . '</h1>';
    echo '<form method="post">';
    wp_nonce_field( 'hi_classic_form_recaptcha_action', 'hi_classic_form_recaptcha_nonce' );
    echo '<table class="form-table">';
    echo '<tr><th scope="row"><label for="hi_classic_form_recaptcha_site_key">' . esc_html__( 'reCAPTCHA v3 Site Key', 'hi-classic-form' ) . '</label></th>';
    echo '<td><input name="hi_classic_form_recaptcha_site_key" id="hi_classic_form_recaptcha_site_key" type="text" value="' . esc_attr( $site_key ) . '" class="regular-text" /></td></tr>';
    echo '<tr><th scope="row"><label for="hi_classic_form_recaptcha_secret_key">' . esc_html__( 'reCAPTCHA v3 Secret Key', 'hi-classic-form' ) . '</label></th>';
    echo '<td><input name="hi_classic_form_recaptcha_secret_key" id="hi_classic_form_recaptcha_secret_key" type="text" value="' . esc_attr( $secret_key ) . '" class="regular-text" /></td></tr>';
    echo '</table>';
    submit_button( esc_html__( 'Save Keys', 'hi-classic-form' ) );
    echo '</form></div>';
}
