(function ($) {
    if (typeof elementorFrontend !== "undefined") {
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/hi_classic_carousel.default",
            function ($scope, $) {
                var $carousels = $scope.find(".hi-classic-carousel");

                $carousels.each(function () {
                    var $this = $(this);
                    if ($this.data("initialized")) return;

                    var autoplay = $this.data("autoplay") || 0;
                    var interval = autoplay ? parseInt(autoplay) : false;
                    var isInfinite =
                        $this.data("infinite") === true ||
                        $this.data("infinite") === "true";

                    var $inner = $this.find(".carousel-inner");
                    var $items = $inner.find(".carousel-item");

                    if ($items.length < 2) return; // no need if only 1 item

                    // ✅ Infinite loop setup (clone first & last)
                    if (isInfinite) {
                        var $first = $items.first().clone(true).addClass("clone-first");
                        var $last = $items.last().clone(true).addClass("clone-last");

                        $inner.append($first);
                        $inner.prepend($last);

                        $inner.find(".carousel-item").removeClass("active");
                        $inner.find(".carousel-item").eq(1).addClass("active");
                    }

                    // ✅ Initialize carousel
                    var carousel = new bootstrap.Carousel($this[0], {
                        interval: interval,
                        ride: interval ? "carousel" : false,
                        wrap: !isInfinite, // disable native wrap if manual loop is on
                        pause: "hover",
                    });

                    // ✅ Handle jump on clone slides
                    if (isInfinite) {
                        $this.on("slid.bs.carousel", function () {
                            var $active = $inner.find(".carousel-item.active");

                            if ($active.hasClass("clone-first")) {
                                carousel.to(1);
                            } else if ($active.hasClass("clone-last")) {
                                carousel.to($items.length - 1);
                            }
                        });
                    }

                    $this.data("initialized", true);
                    console.log("✅ Hi Classic Carousel initialized", $this.attr("id"));
                });
            }
        );
    }
})(jQuery);
