(function ($) {
    $(window).on('elementor:init', function () {
        // Fires when any Elementor template is saved
        elementor.channels.data.on('template:save', function () {
            setTimeout(function () {
                console.log('🔄 Hi Classic Carousel: Template saved, refreshing dropdown...');
                
                const panel = elementor.getPanelView().getCurrentPageView();
                if (!panel || !panel.collection) return;

                // Loop through all controls in the current widget editor panel
                panel.collection.each(function (controlView) {
                    // For repeaters, we need to look deeper inside repeater items
                    if (controlView.collection) {
                        controlView.collection.each(function (subControlView) {
                            if (
                                subControlView.model &&
                                subControlView.model.get('name') === 'slide_template'
                            ) {
                                console.log('🔁 Refreshing slide_template inside repeater...');
                                subControlView.render();
                            }
                        });
                    } else if (
                        controlView.model &&
                        controlView.model.get('name') === 'slide_template'
                    ) {
                        // If not inside repeater
                        console.log('🔁 Refreshing slide_template...');
                        controlView.render();
                    }
                });
            }, 1200);
        });
    });
})(jQuery);
